import DSE_DiffARM
import gossip_8point_2
import Distributed_UCB_8point
import matplotlib.pyplot as plt
import os

if __name__ == '__main__':
    Dis_mean,Dis_std_1,Dis_std_2 = Distributed_UCB_8point.Distri()
    Gos_mean,Gos_std_1,Gos_std_2 = gossip_8point_2.GOS()
    DES_mean,DES_std_1,DSE_std_2 = DSE_DiffARM.DSE_DiffAEM_list()

    plt.plot([8, 10, 12, 14, 16], DES_mean, linestyle='--', color='blue', marker='^',markerfacecolor='none',  markersize=10, label = 'DRRB-bandit')
    plt.plot([8, 10, 12, 14, 16], Dis_mean, linestyle=':', color='red', marker='*', markerfacecolor='none', markersize=10, label = 'Dis_UCB')
    plt.plot([8, 10, 12, 14, 16], Gos_mean, linestyle='-', color='green', marker='o', markerfacecolor='none',markersize=10, label = 'Gossip_UCB')

    plt.fill_between([8, 10, 12, 14, 16],DES_std_1,DSE_std_2,color='lightblue', alpha=0.2)
    plt.fill_between([8, 10, 12, 14, 16], Dis_std_1, Dis_std_2, color='lightcoral', alpha=0.2)
    plt.fill_between([8, 10, 12, 14, 16], Gos_std_1, Gos_std_2, color='lightgreen', alpha=0.2)


    # plt.grid(True, linestyle='--')
    # plt.title('Average Individual Regret')
    plt.xlabel(r'Number of Arms $K$', fontsize=20)
    plt.ylabel('Regret', fontsize=20)
    plt.xticks(fontsize=20)
    plt.yticks(fontsize=20)
    from matplotlib.font_manager import FontProperties
    font_prop = FontProperties(family="Times New Roman", size=20)
    plt.tight_layout()
    # plt.legend(prop=font_prop)
    # plt.legend(['Gossip_UCB','Dis_UCB','CES-bandit'])
    # plt.savefig('multi_armed.png', dpi=1200)~/zhr/3K/graph
    plt.savefig(os.path.join('multi_armed_3method3.png'))

    # plt.xlabel('Time', fontsize=15)
    # plt.ylabel('Regret', fontsize=15)
    # plt.xticks(fontsize=15)
    # plt.yticks(fontsize=15)
    # from matplotlib.font_manager import FontProperties
    # font_prop = FontProperties(family="Times New Roman", size=16)
    # plt.legend(prop=font_prop)
    # plt.legend()
    # plt.show()
    # plt.savefig('different_gamma.png', dpi=400)
    # plt.savefig(os.path.join('/home/amax/zhr/7k/graph', 'worse_sigma.png'))